﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

/**
*   @file
*   @brief  LOG 取得に関する定義
*/


/**
 * @enum LogReaderResult
 * ログ取得操作の結果
 */
enum LogReaderResult
{
    //! 操作に成功した場合の値です。
    LogReaderResult_Success = 0,

    //! 接続に失敗した場合の値です。
    LogReaderResult_ConnectFailed = -1,

    //! 既にログ取得を開始している状態で、さらにログ取得開始を実行した場合の値です。
    LogReaderResult_AlreadyStarted = -2,

    //! タイムアウトした場合の値です。
    LogReaderResult_Timeout = -3,

    //! 検索したログが見つからなかった場合の値です。
    LogReaderResult_NotFound = -4,

    //! 不正な引数を指定した場合の値です。
    LogReaderResult_InvalidArgument = -5,

    //! それ以上移動できない場合の値です。
    LogReaderResult_CannotMoveLine = -6,
};

