﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#pragma once

/**
*   @file
*   @brief  HID 入力操作に関する定義
*/

/**
 * @enum HidInputerResult
 * HidInputer ライブラリの汎用エラー
 */
enum HidInputerResult
{
    //! 操作が成功したときの値です。
    HidInputerResult_Success                 = 0,

    //! 不測のエラーが発生したときの値です。
    HidInputerResult_Unexpected              = -1,

    //! 対象ターゲットが見つからなかったときの値です。
    HidInputerResult_TargetNotFound          = -2,

    //! 未初期化状態で呼び出されたときの値です。
    HidInputerResult_NotInitialized          = -3,
};

/**
 * @enum ControllerResult
 * コントローラー操作の結果
 */
enum ControllerResult
{
    //! 操作が成功したときの値です。
    ControllerResult_Success                 = 0,

    //! 不測のエラーが発生したときの値です。
    ControllerResult_Unexpected              = -1,

    //! コントローラー接続に失敗したときの値です。
    ControllerResult_ConnectControllerFailed = -2,

    //! 不正なコントローラー ID が指定されていたときの値です。
    ControllerResult_InvalidControllerId     = -3,

    //! 不正なボタンに対して操作が実行されたときの値です。
    ControllerResult_InvalidButton       = -4,

    //! 不正なスティックに対して操作が実行されたときの値です。
    ControllerResult_InvalidStick        = -5,

    //! 不正なデバイス種別とインターフェース種別の組み合わせが指定されたときの値です。
    ControllerResult_InvalidDeviceInfo = -6,

    //! 既にデバイスが接続されていたときの値です。
    ControllerResult_AlreadyConnected  = -7,

    //! 接続可能なコントローラー数を超えたときの値です。
    ControllerResult_ControllerCountOver = -8,

    //! 未初期化状態で呼び出されたときの値です。
    ControllerResult_NotInitialized = -9,
};

/**
 * @enum TouchResult
 * タッチスクリーン入力操作の結果
 */
enum TouchResult
{
    //! 操作に成功したときの値です。
    TouchResult_Success = 0,

    //! 不測のエラーが発生したときの値です。
    TouchResult_Unexpected = -1,

    //! 不正なタッチ ID に対して操作が実行されたときの値です。
    TouchResult_InvalidTouchId = -2,

    //! 不正な fingerId に対して操作が実行されたときの値です。
    TouchResult_InvalidFingerId = -3,

    //! 未初期化状態で呼び出されたときの値です。
    TouchResult_NotInitialized = -4,
};

/**
 * @enum Button
 * ボタン種別
 */
enum Button
{
    //! HOME ボタン
    Button_Home = -2,

    //! キャプチャボタン
    Button_Capture = -1,

    //! A ボタン
    Button_A = 0,

    //! B ボタン
    Button_B = 1,

    //! X ボタン
    Button_X = 2,

    //! Y ボタン
    Button_Y = 3,

    //! L スティックボタン
    Button_StickL = 4,

    //! R スティックボタン
    Button_StickR = 5,

    //! L ボタン
    Button_L = 6,

    //! R ボタン
    Button_R = 7,

    //! ZL ボタン
    Button_ZL = 8,

    //! ZR ボタン
    Button_ZR = 9,

    //! プラスボタン
    Button_Plus = 10,

    //! マイナスボタン
    Button_Minus = 11,

    //! 十字ボタン左
    Button_Left = 12,

    //! 十字ボタン上
    Button_Up = 13,

    //! 十字ボタン右
    Button_Right = 14,

    //! 十字ボタン下
    Button_Down = 15,

    //! SL ボタン
    Button_SL   = 16,

    //! SR ボタン
    Button_SR   = 17,

    Button_MaxCount,
};

/**
 * @enum Stick
 * アナログスティック種別
 */
enum Stick
{
    //! 左アナログスティック
    Stick_L = 0,

    //! 右アナログスティック
    Stick_R,

    Stick_MaxCount
};

/**
 * @enum ControllerDeviceType
 * コントローラーのデバイス種別
 */
enum ControllerDeviceType
{
    //! Switch Pro コントローラー
    ControllerDeviceType_SwitchProController = 0,

    //! 左 Joy-Con
    ControllerDeviceType_JoyConLeft,

    //! 右 Joy-Con
    ControllerDeviceType_JoyConRight
};

/**
 * @enum ControllerInterfaceType
 * コントローラーの接続インターフェース種別
 */
enum ControllerInterfaceType
{
    //! Bluetooth
    ControllerInterfaceType_Bluetooth = 0,

    //! 本体レール
    ControllerInterfaceType_Rail
};

/**
 * @struct ControllerDeviceInfo
 * コントローラーデバイスの情報
 */
struct ControllerDeviceInfo
{
    //! デバイスタイプ
    ControllerDeviceType deviceType;

    //! 接続インターフェースタイプ
    ControllerInterfaceType interfaceType;

    //! メイン色(0 <= R <= 255, 0 <= G <= 255, 0 <= B <= 255 )
    int mainColor[3];

    //! サブ色(0 <= R <= 255, 0 <= G <= 255, 0 <= B <= 255 )
    int subColor[3];
};
