﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace SettingsManager
{
    using System;
    using System.Collections.Generic;
    using System.ComponentModel.Composition.Hosting;
    using System.Globalization;
    using System.IO;
    using System.Linq;
    using System.Reflection;
    using System.Threading;
    using Nintendo.ToolFoundation.CommandLine;

    /// <summary>
    /// エントリーポイントを定義します。
    /// </summary>
    internal static class Program
    {
        /// <summary>
        /// エントリーポイントです。
        /// </summary>
        /// <param name="args">コマンドラインオプションです。</param>
        internal static void Main(string[] args)
        {
            try
            {
                if (File.Exists(ResourceManager.ResourceLocalizerPath))
                {
                    var cultureInfo = new CultureInfo("en", false);

                    Thread.CurrentThread.CurrentUICulture = cultureInfo;
                }

                IEnumerable<ICommand> commands = GetExportedCommands();

                var parser = new DelegateBasedCommandLineParser();

                parser.AddHelp(Console.Error.WriteLine);

                foreach (ICommand command in commands)
                {
                    command.RegiserWith(parser);
                }

                if (!parser.ParseArgs(args, Console.Error.WriteLine))
                {
                    Environment.Exit(1);
                }

                commands.First(x => x.IsSelected).Execute();
            }
            catch (Exception ex)
            {
                Console.Error.WriteLine(ex.Message);

                Environment.Exit(1);
            }
        }

        private static IEnumerable<ICommand> GetExportedCommands()
        {
            Assembly assembly = Assembly.GetExecutingAssembly();
            using (var catalog = new AssemblyCatalog(assembly))
            using (var container = new CompositionContainer(catalog))
            {
                return container.GetExportedValues<ICommand>();
            }
        }
    }
}
