﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace ReadInitialImage.Commands
{
    class ReadCommands : CommandCommon
    {
        public override void Run()
        {
            RunCommand(reader =>
            {
                var commands = reader.Commands;
                Console.WriteLine(string.Format("NumCommands: {0}", commands.Count()));
                Console.WriteLine(string.Format("Commands:"));
                foreach (var command in commands)
                {
                    Console.WriteLine(string.Format("  - Name:      {0}", command.Command.ToString()));
                    Console.WriteLine(string.Format("    Arguments: [{0}]", string.Join(", ",command.Arguments)));
                    Console.WriteLine(string.Format("    StringArg: {0}", command.StringArgument));
                }
            });
        }
    }
}
