﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.IO;
using CommandUtility;
using Nintendo.Foundation.IO;

namespace MakeSignedBinary.Commands
{
    public class InfoCommand : SubCommandCommon
    {
        [CommandLineOption('i', "input", Description = "input file")]
        public string InputFile { get; set; }

        public override int Run()
        {
            using (var reader = File.OpenRead(InputFile))
            {
                var signature = BinaryUtility.ReadBytes(reader, 256);

                var header = SignedBinaryHeader.Load(reader);

                Console.WriteLine($"Signature:     {BinaryUtility.ToPrettyHexString(signature)}");
                Console.WriteLine($"Version:       {header.Version}");
                Console.WriteLine($"Size:          {header.Size}");
                Console.WriteLine($"IV:            {BinaryUtility.ToPrettyHexString(header.IV)}");
                Console.WriteLine($"Hash:          {BinaryUtility.ToPrettyHexString(header.ContentHash)}");
                Console.WriteLine($"KeyGeneration: {header.KeyGeneration}");
                Console.WriteLine($"AppendHash:    {header.AppendHashCount}");
                for (int i = 0; i < header.AppendHashCount; i++)
                {
                    Console.WriteLine($"    - [{i}] size={header.AppendHashInfos[i].Size}, hash={BinaryUtility.ToPrettyHexString(header.AppendHashInfos[i].Hash)}");
                }
                Console.WriteLine($"DataHead:  {BinaryUtility.ToPrettyHexString(BinaryUtility.ReadBytes(reader, 16))}");
            }

            return 0;
        }
    }
}
