﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using CommandUtility;
using Nintendo.Foundation.IO;
using System.IO;
using YamlDotNet;
using System.Security.Cryptography;
using System.Text.RegularExpressions;

namespace MakeSignedBinary.Commands
{
    public class GenerateConfig : SubCommandCommon
    {
        [CommandLineOption('o', "output", Description = "output file")]
        public string OutputFile { get; set; }

        public override int Run()
        {
            var config = KeyConfig.Generate();

            var yamlConfig = config.DumpYaml();

            if(OutputFile == null)
            {
                Console.WriteLine(yamlConfig);
            }
            else
            {
                using (var output = File.CreateText(OutputFile))
                {
                    output.WriteLine(yamlConfig);
                }
            }

            return 0;
        }
    }
}
