﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using Nintendo.Foundation.IO;
using CommandUtility;

namespace MakeRecoveryWriter
{
    public class MakeRecoveryWriterArguments
    {
        [CommandLineSubCommand("make", Description = "make recovery writer.")]
        public Commands.MakeRecoveryWriterCommand MakeRecoveryWriterCommand { get; set; }

        [CommandLineSubCommand("info", Description = "print infos of recovery writer image.")]
        public Commands.GetInfoCommand GetInfoCommand { get; set; }

        [CommandLineSubCommand("extract", Description = "extract parts from recovery writer image.")]
        public Commands.ExtractCommand ExtractCommand { get; set; }
    }

    public class Program
    {
        public static void Main(string[] args)
        {
#if !DEBUG
            try
            {
#endif
            System.Environment.Exit(
                MultiCommandRunner<MakeRecoveryWriterArguments>.Run(args));
#if !DEBUG
            }
            catch (Exception exception)
            {
                Console.Error.WriteLine("[ERROR] {0}", exception.Message);
                Console.Error.WriteLine("{0}", exception.StackTrace);
                Environment.Exit(1);
            }
#endif
        }
    }
}
