﻿using System;
using CommandUtility;
using Nintendo.Foundation.IO;
using System.IO;

namespace MakeRecoveryWriter.Commands
{
    public class GetInfoCommand : SubCommandCommon
    {
        [CommandLineOption('i', "input", Description = "input recovery writer image file")]
        public string InputFile { get; set; }

        public override int Run()
        {
            var fileInfo = new FileInfo(InputFile);
            using (var reader = fileInfo.OpenRead())
            {
                var parameter = RecoveryWriterImage.LoadParameter(reader);
                const int Kibi = 1024;

                Console.WriteLine(
$@"File:
    Name: {fileInfo.FullName}
    TotalSize:        0x{fileInfo.Length:X8}, {(fileInfo.Length + Kibi - 1) / Kibi} KB
GPT:
    Offset (on Qspi): 0x{RecoveryWriterImage.GptOffset:X8}, {(RecoveryWriterImage.GptOffset + Kibi - 1) / Kibi} KB
    Size (bytes):     0x{RecoveryWriterImage.GptSize:X8}, {(RecoveryWriterImage.GptSize + Kibi - 1) / Kibi} KB
Bct:
    Offset (on Qspi): 0x{parameter.BctOffsetOnQspi:X8}, {(parameter.BctOffsetOnQspi + Kibi - 1) / Kibi} KB
    Size (bytes):     0x{parameter.BctSize:X8}, {(parameter.BctSize + Kibi - 1) / Kibi} KB
BootLoader:
    Offset (on Qspi): 0x{parameter.BootLoaderOffsetOnQspi:X8}, {(parameter.BootLoaderOffsetOnQspi + Kibi - 1) / Kibi} KB
    Size (bytes):     0x{parameter.BootLoaderSize:X8}, {(parameter.BootLoaderSize + Kibi - 1) / Kibi} KB
Package2:
    Offset (on Qspi): 0x{parameter.Package2OffsetOnQspi:X8}, {(parameter.Package2OffsetOnQspi + Kibi - 1) / Kibi} KB
    Size (bytes):     0x{parameter.Package2Size:X8}, {(parameter.Package2Size + Kibi - 1) / Kibi} KB
SystemPartition:
    Offset (on Qspi): 0x{parameter.SystemPartitionOffsetOnQspi:X8}, {(parameter.SystemPartitionOffsetOnQspi + Kibi - 1) / Kibi} KB
    Size (bytes):     0x{parameter.SystemPartitionSize:X8}, {(parameter.SystemPartitionSize + Kibi - 1) / Kibi} KB
End:
    Offset (on Qspi): 0x{parameter.SystemPartitionOffsetOnQspi + parameter.SystemPartitionSize:X8}, {(parameter.SystemPartitionOffsetOnQspi + parameter.SystemPartitionSize + Kibi - 1) / Kibi} KB
");
            }

            return 0;
        }
    }
}
