﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.IO;
using System.Threading.Tasks;
using Nintendo.Foundation.IO;
using System.Text.RegularExpressions;
using CommandUtility;

namespace MakeInstalledFatImage
{
    public class MakeInstalledFatImageArguments
    {
        [CommandLineOption('o', "output", Description = " ", IsRequired = true)]
        public string OutputPath { get; set; }

        [CommandLineOption('i', "input", Description = " ", IsRequired = true)]
        public string[] InputPathList { get; set; }

        [CommandLineOption('s', "size", Description = "Set fat iamge size(MiB)", IsRequired = true)]
        public Int64 Size { get; set; }

        [CommandLineOption("sparse-image", Description = "Create sparse fat image")]
        public bool isSparseImage { get; set; }

        [CommandLineOption("base-directory", Description = "Create from base directory")]
        public string BaseDirectory { get; set; }

        [CommandLineOption("storage-type", Description = "Set storage type", DefaultValue="system")]
        public string StorageType { get; set; }

        [CommandLineOption("tool-make-fat-image", Description = " ", IsRequired = false)]
        public string MakeFatImagePath { get; set; }

        [CommandLineOption("tool-install-nsp", Description = " ", IsRequired = false)]
        public string InstallNspPath { get; set; }

        [CommandLineOption("delete", Description = " ", IsRequired = false)]
        public string[] deletingFiles { get; set; }

        [CommandLineOption("key-file", Description = " ", IsRequired = false)]
        public string KeyFilePath { get; set; }

        [CommandLineOption("copy-file", Description = " ", IsRequired = false)]
        public string[] CopiedFiles { get; set; }

        [CommandLineOption("ensure-free-space", Description = " ", IsRequired = false)]
        public string EnsuredFreeSpace { get; set; }
    }

    public class Program
    {
        public static void Main(string[] args)
        {
#if !DEBUG
            try
            {
#endif
            MakeInstalledFatImageArguments parameters = new MakeInstalledFatImageArguments();
            if (CommandLineParser.Default.ParseArgs<MakeInstalledFatImageArguments>(args, out parameters))
            {
                var inputFiles = (from filename in parameters.InputPathList select new FileInfo(filename)).ToList();
                var outputFile = new FileInfo(parameters.OutputPath);
                var makeFatImagePath = MakeInitialImage.Utility.EnsureExeFile(parameters.MakeFatImagePath, "MakeFatImage.exe");
                var installNspPath = MakeInitialImage.Utility.EnsureExeFile(parameters.InstallNspPath, "InstallNspOnHost.exe");
                var baseDirectory = parameters.BaseDirectory == null ? null : new DirectoryInfo(parameters.BaseDirectory);
                var keyFile = parameters.KeyFilePath == null ? null : MakeInitialImage.Utility.EnsureExistFile(parameters.KeyFilePath);
                var fatImage = new MakeInitialImage.InstalledFatImage(makeFatImagePath, installNspPath, parameters.deletingFiles.ToList());
                var ensuredFreeSpace = parameters.EnsuredFreeSpace == null ? 0 : ByteUnitExpression.Parse(parameters.EnsuredFreeSpace).Bytes;

                fatImage.AddPreprocessor(new MakeInitialImage.CopyFilesPreprocessor(parameters.CopiedFiles));

                fatImage.Create(outputFile, baseDirectory, inputFiles, parameters.StorageType, parameters.Size, parameters.isSparseImage, keyFile, ensuredFreeSpace);
            }
            else
            {
                return;
            }
#if !DEBUG
            }
            catch (Exception exception)
            {
                Console.Error.WriteLine("エラー: {0}", exception.Message);
                Console.Error.WriteLine("{0}", exception.StackTrace);
                Environment.Exit(1);
            }
#endif
        }
    }
}
