﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using Nintendo.Foundation.IO;

namespace MakeInitialImage
{
    public class MakeInitialImageArguments
    {
        [CommandLineOption('o', "output", Description = " ", IsRequired = true)]
        public string OutputPath { get; set; }

        [CommandLineOption('i', "input", Description = " ", IsRequired = true)]
        public string InputPath { get; set; }

        [CommandLineOption('D', "define", Description = " ", IsRequired = false)]
        public string[] Arguments { get; set; }

        [CommandLineOption("tool-make-fat-image", Description = " ", IsRequired = false)]
        public string MakeFatImagePath { get; set; }

        [CommandLineOption("tool-install-nsp", Description = " ", IsRequired = false)]
        public string InstallNspPath { get; set; }

        [CommandLineOption("dump-processed-config", Description = " ", IsRequired = false)]
        public bool DumpProcessedConfig { get; set; }

        public Dictionary<string, string> MakeVariablesDictionary()
        {
            var dictionary = new Dictionary<string, string>();
            if (Arguments == null)
            {
                return new Dictionary<string, string>();
            }
            else
            {
                foreach (var text in Arguments)
                {
                    var splitted = text.Split(new char[] { '=' }, 2);

                    if (splitted.Length != 2)
                    {
                        throw new ArgumentException("Invalid variable definition format: " + text);
                    }

                    dictionary[splitted[0]] = splitted[1];
                }

                return dictionary;
            }
        }
    }
}
