﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.IO;

namespace MakeInitialImage
{
    public class GuidPartitionTableWriter
    {
        public void WriteMbr(Stream output)
        {
            Utility.WriteBinary<ProtectiveMbr>(output, ProtectiveMbr.Create());
        }

        public void WriteHeader(Stream output)
        {
            Utility.WriteBinary<GptHeader>(output, GptHeader.Create(Guid.NewGuid(), numPartitions));
        }

        public void WritePartitionEntries(Stream output)
        {
            long currentAddress = 0;

            foreach (var partition in partitionDictionary)
            {
                Utility.WriteBinary<GptPartitionEntry>(
                    output,
                    GptPartitionEntry.Create(
                        partitionType:  partitionTypeGuids[partition.Key],
                        partitionGuid:  partitionGuids[partition.Key],
                        startingLba:    currentAddress,
                        endingLba:      currentAddress + partitionSizes[partition.Key],
                        attributes:     attributes[partition.Key],
                        partitionName:  partition.Key));

                currentAddress += currentAddress + partitionSizes[partition.Key];
            }
        }

        public void AddPartition(string name, long size, Guid partitionTypeGuid, Guid partitionGuid, bool isRequiredPartition)
        {
            partitionDictionary[name] = numPartitions;
            partitionTypeGuids[name] = partitionTypeGuid;
            partitionGuids[name] = partitionGuid;
            partitionSizes[name] = size;
            attributes[name] = MakeAttribute(isRequiredPartition);
            numPartitions += 1;
        }

        public int GetPartitionIndex(string name)
        {
            if (!partitionDictionary.ContainsKey(name))
            {
                throw new Exception(string.Format("Found no GPT partitions: {0}", name));
            }

            return partitionDictionary[name];
        }

        public static ulong MakeAttribute(bool isRequiredPartition)
        {
            ulong attribute = 0;

            if (isRequiredPartition)
            {
                attribute = attribute | 1;
            }

            return attribute;
        }

        private int numPartitions = 0;
        private Dictionary<string, int> partitionDictionary = new Dictionary<string, int>();
        private Dictionary<string, Guid> partitionTypeGuids = new Dictionary<string, Guid>();
        private Dictionary<string, Guid> partitionGuids = new Dictionary<string, Guid>();
        private Dictionary<string, long> partitionSizes = new Dictionary<string, long>();
        private Dictionary<string, ulong> attributes = new Dictionary<string, ulong>();
    }
}
