﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Result.h>
#include <nn/fssystem/fs_AesXtsStorage.h>
#include <nn/fssystem/fs_AlignmentMatchingStorage.h>

struct AesXtsStorageSource
{
    uint8_t key1[nn::fssystem::AesXtsStorage::KeySize];
    uint8_t key2[nn::fssystem::AesXtsStorage::KeySize];
};

bool IsFile(std::string path);
bool IsDirectory(std::string path);
std::string CombinePath(std::string head, std::string tail);
nn::Result LoadAesStorageSource(AesXtsStorageSource *pAesStorageSource, const char* encryptionKeyFile);
nn::Result MakeFatImage(const char* outputPath, long sizeMiB, const char* inputDirectory, bool makeSparseImage, bool enableEncryption, const char *encryptionKeyFile, int64_t ensuredFreeSpace);
