﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <string>
#include <vector>
#include <random>

#include <nn/nn_Result.h>
#include <nn/result/result_HandlingUtility.h>
#include <nn/nn_Log.h>
#include <nn/nn_Assert.h>
#include <nn/nn_Abort.h>
#include <nn/util/util_ScopeExit.h>

#include <nn/fs.h>
#include <nn/fs/fsa/fs_Registrar.h>
#include <nn/os.h>

#include <nn/ncm/ncm_Result.h>
#include <nn/ncm/ncm_ContentStorageImpl.h>
#include <nn/ncm/ncm_IContentStorage.h>
#include <nn/ncm/ncm_ContentStorage.h>
#include <nn/ncm/ncm_ContentIdUtil.h>

#include <nn/crypto/crypto_Sha256Generator.h>

#include <nn/sf/sf_StdAllocationPolicy.h>
#include <nn/sf/sf_ObjectFactory.h>
#include <new>

#include "InstallNspOnHost.h"

namespace{

    void* Allocate(size_t size)
    {
        return malloc(size);
    }

    void Deallocate(void* p, size_t size)
    {
        NN_UNUSED(size);
        return free(p);
    }

} // namespace

extern "C" void nnMain()
{
    char **argv = nn::os::GetHostArgv();
    int argc = nn::os::GetHostArgc();

    if (argc != 4)
    {
        NN_LOG("usage:\n");
        NN_LOG("    InstallNspOnHost <installStorage=system,user> <OutputDirecotry> <Nsp>\r\n");

        for(int i=0; i< argc;i++)
        {
            NN_LOG("input[%d]: %s\r\n", i, argv[i]);
        }

        return;
    }

    nn::fs::SetAllocator(Allocate, Deallocate);
    nn::fs::MountHostRoot();

    nn::Result result = InstallNsp(argv[1], argv[2], argv[3]);

    if (result.IsFailure())
    {
        NN_LOG("failure: nn::Result=%08x, module=%d, description=%d\n", result.GetInnerValueForDebug(), result.GetModule(), result.GetDescription());
        NN_LOG("Arguments:\n");
        int numArgs = nn::os::GetHostArgc();
        for(int i = 0; i < numArgs; i++)
        {
            NN_LOG("  %d: %s\n", i, nn::os::GetHostArgv()[i]);
        }

        std::exit(1);
    }
}
