﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.IO;
using Nintendo.Foundation.IO;
using CommandUtility;
using System.Text.RegularExpressions;

namespace CmacFileTool
{
    public class CmacFileToolArgument
    {
        [CommandLineSubCommand("append", Description="append cmac to file")]
        public Commands.AppendCmacCommand AppendCmacCommand { get; set; }

        [CommandLineSubCommand("verify", Description="verify cmac file")]
        public Commands.VerifyCmacCommand VerifyCmacCommand { get; set; }

        [CommandLineSubCommand("change", Description = "change cmac key of cmac file")]
        public Commands.ChangeKeyCommand ChangeKeyCommand { get; set; }

        [CommandLineSubCommand("remove", Description = "remove cmac key of cmac file")]
        public Commands.RemoveCmacCommand RemoveCmacCommand { get; set; }
    }

    class Program
    {
        static void Main(string[] args)
        {
#if !DEBUG
            try
            {
#endif
            CmacFileToolArgument parameters = new CmacFileToolArgument();
            if (CommandLineParser.Default.ParseArgs<CmacFileToolArgument>(args, out parameters))
            {
                if (parameters.AppendCmacCommand != null)
                {
                    parameters.AppendCmacCommand.Run();
                }
                else if(parameters.VerifyCmacCommand != null)
                {
                    parameters.VerifyCmacCommand.Run();
                }
                else if (parameters.ChangeKeyCommand != null)
                {
                    parameters.ChangeKeyCommand.Run();
                }
                else if (parameters.RemoveCmacCommand != null)
                {
                    parameters.RemoveCmacCommand.Run();
                }
                else
                {
                    throw new Exception("found no subcommand");
                }
            }
            else
            {
                return;
            }
#if !DEBUG
            }
            catch (Exception exception)
            {
                Console.Error.WriteLine("エラー: {0}", exception.Message);
                Console.Error.WriteLine("{0}", exception.StackTrace);
                Environment.Exit(1);
            }
#endif
        }
    }
}
