﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.IO;
using Nintendo.Foundation.IO;
using CommandUtility;
using System.Text.RegularExpressions;

namespace CmacFileTool.Commands
{
    public class VerifyCmacCommand
    {
        [CommandLineOption('i', "input",
            Description = "set initial image with cmac",
            IsRequired = true)]
        public string InputFile { get; set; }

        [CommandLineOption("key",
            Description = "set key.(binary-file-path or text-file-path or 32-hexchars)",
            IsRequired = true)]
        public string CmacKek { get; set; }

        public void Run()
        {
            var cmacKek = AppendCmacCommand.LoadKeyFromArgument(CmacKek);
            var inputFileInfo = new FileInfo(InputFile);
            using (var reader = inputFileInfo.OpenRead())
            {
                // ヘッダ読む
                var header = CmacFileHeader.Load(reader, cmacKek);

                for (int blockIndex = 0; blockIndex < header.NumberOfBlocks; blockIndex++)
                {
                    // CMAC の読み込み
                    var cmac = new byte[16];
                    reader.Read(cmac, 0, cmac.Length);

                    // データの読み込み
                    var indexData = BinaryUtility.ToBinary<int>(blockIndex);
                    var buffer = new byte[indexData.Length + header.BlockSize];
                    indexData.CopyTo(buffer, 0);
                    reader.Read(buffer, indexData.Length, header.BlockSize);

                    // 検証
                    CmacUtility.Verify(buffer, cmac, header.CmacKey);
                }
            }
        }
    }
}
