﻿namespace Nintendo.Log
{
    internal static class StringExtentions
    {
        public static string PadCenter(this string value, int totalWidth)
        {
            return value.PadLeft(((totalWidth - value.Length) / 2) + value.Length).PadRight(totalWidth);
        }

        public static string PackCenter(this string value, int totalWidth)
        {
            return value.PadCenter(totalWidth).Substring(0, totalWidth);
        }

        public static string PackLeft(this string value, int totalWidth)
        {
            return value.PadRight(totalWidth).Substring(0, totalWidth);
        }

        public static string PackRight(this string value, int totalWidth)
        {
            return value.PadLeft(totalWidth).Substring(0, totalWidth);
        }
    }
}
