﻿using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace Nintendo.Log
{
    internal class LogViewerFileTab : LogViewerTab
    {
        public LogViewerFileTab()
            : this("Log", "")
        {
        }

        public LogViewerFileTab(string text, string filePath)
            : base(text)
        {
            this.HandleCreated += (sender, e) =>
            {
                Task.Factory.StartNew(state => ReadFunc((string)state), filePath);
            };
        }

        public new void Dispose()
        {
            // TODO: Task の終了

            LogTextForeColorChanged -= LogViewerTab_LogTextForeColorChanged;
            LogTextBackColorChanged -= LogViewerTab_LogTextBackColorChanged;
            LogTextFontChanged -= LogViewerTab_LogTextFontChanged;
        }

        private static List<Dictionary<string, object>> GetLogsFromFile(string path)
        {
            var extension = Path.GetExtension(path).ToLower();
            if (!(extension == ".nxbinlog" || extension == ".json"))
            {
                throw new ArgumentException();
            }

            var logs = extension == ".nxbinlog"
                ? LogClient.GetLogsFromNxbinlog(path)
                : LogClient.GetLogsFromJson(path);

            // ForegroundLogCountMax より多く読み込んでも、表示できないため、
            // 暫定的に、先頭から ForegroundLogCountMax 個だけログを読み込む。
            return logs.Take(ForegroundLogCountMax).ToList();

        }

        private void ReadFunc(string filePath)
        {
            lock (BackgroundLogBuffer)
            {
                try
                {
                    BackgroundLogBuffer = GetLogsFromFile(filePath);
                }
                catch
                {
                    MessageBox.Show("Invalid file.", "Error", MessageBoxButtons.OK, MessageBoxIcon.Error);
                    return;
                }

                if (!BackgroundLogBuffer.Any())
                {
                    return;
                }

                BackgroundLogBeginIndex = 0;
                BackgroundLogEndIndex = BackgroundLogBuffer.Count();
                UpdatePartial();
            }
            UpdateFunc();
        }
    }
}
