﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks.Dataflow;
using System.Xml.Linq;

namespace Nintendo.Log
{
    class XmlLogPort : IDisposable
    {
        public XmlLogPort(string peerName, string portName, ISourceBlock<Dictionary<string, object>> sourceBlock)
        {
            TrasnformBlockLinkDisposer = sourceBlock.LinkTo(TransformBlock,
                log => (string)log["PeerName"] == peerName);

            LogPortEmulator = new LogPortEmulator(peerName, portName, TransformBlock);
        }

        public void Dispose()
        {
            TransformBlock.Complete();
            TransformBlock.Completion.Wait();
            TrasnformBlockLinkDisposer.Dispose();
            LogPortEmulator.Dispose();
        }

        TransformBlock<Dictionary<string, object>, string> TransformBlock =
            new TransformBlock<Dictionary<string, object>, string>(
                log =>
                {
#if false // パース可能な XML を生成していることを確認したいときに true にする。
                    var text = LogConverter.ToXmlText(log, IsPretty);
                    var dictionary = XElement.Parse(text).Elements().ToDictionary(e => e.Name, e => (object)e.Value);
                    return dictionary.ContainsKey("TextLog")
                        ? (string)dictionary["TextLog"]
                        : string.Empty;
#else
                    return LogConverter.ToXmlText(log, IsPretty) + Environment.NewLine;
#endif
                });

        private static readonly bool IsPretty = false; // 整形された XML で確認したいときに true にする。
        private IDisposable TrasnformBlockLinkDisposer;
        LogPortEmulator LogPortEmulator;
    }
}
