﻿using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Threading.Tasks.Dataflow;

namespace Nintendo.Log
{
    class LogPort : IDisposable
    {
        public LogPort(string peerName, string portName, ISourceBlock<Dictionary<string, object>> sourceBlock)
        {
            TrasnformBlockLinkDisposer = sourceBlock.LinkTo(TransformBlock,
                log => (string)log["PeerName"] == peerName &&
                    (log.ContainsKey("TextLog") || log.ContainsKey("LogSessionEnd")));

            LogPortEmulator = new LogPortEmulator(peerName, portName, TransformBlock);
        }

        public void Dispose()
        {
            TransformBlock.Complete();
            TransformBlock.Completion.Wait();
            TrasnformBlockLinkDisposer.Dispose();
            LogPortEmulator.Dispose();
        }

        TransformBlock<Dictionary<string, object>, string> TransformBlock =
            new TransformBlock<Dictionary<string, object>, string>(
                log =>
                {
                    if (log.ContainsKey("TextLog"))
                    {
                        return (string)log["TextLog"];
                    }
                    else
                    {
                        Debug.Assert(log.ContainsKey("LogSessionEnd"));
                        return "\0\0\0\0"; // エミュレーションポートはセッション終了を null x4 で表現する
                    }
                });

        private IDisposable TrasnformBlockLinkDisposer;
        private LogPortEmulator LogPortEmulator;
    }
}
