﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

using Nintendo.HtcTools;

namespace Nintendo.HtcTools.Htclow
{
    /// <summary>
    /// 不正なチャンネルの状態遷移が行われたことを示す例外です。
    /// この例外の発生は、HtclowLibrary のプログラミング上の誤りを表します。
    /// </summary>
    [Serializable]
    internal class ChannelStateTransitionException : Exception
    {
        public ChannelState Current { get; set; }
        public ChannelState Next { get; set; }
    }

    /// <summary>
    /// シーケンス ID が期待値と一致しなかったことを示す例外です。
    /// </summary>
    [Serializable]
    internal class ChannelSequenceIdException : Exception
    {
        public long Expect { get; set; }
        public long Actual { get; set; }
    }
}
