﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Nintendo.HtcTools
{
    public sealed class HtclowWriter : IDisposable
    {
        private readonly HtclowChannel m_Channel;
        private readonly bool m_LeaveOpen;

        public HtclowWriter(HtclowChannel channel)
            : this(channel, false)
        {
        }

        public HtclowWriter(HtclowChannel channel, bool leaveOpen)
        {
            m_Channel = channel;
            m_LeaveOpen = leaveOpen;
        }

        public void Write(byte[] buffer)
        {
            m_Channel.Send(buffer);
        }

        public void Write(short value)
        {
            Write(BitConverter.GetBytes(value));
        }

        public void Write(ushort value)
        {
            Write(BitConverter.GetBytes(value));
        }

        public void Write(int value)
        {
            Write(BitConverter.GetBytes(value));
        }

        public void Write(uint value)
        {
            Write(BitConverter.GetBytes(value));
        }

        public void Write(long value)
        {
            Write(BitConverter.GetBytes(value));
        }

        public void Write(ulong value)
        {
            Write(BitConverter.GetBytes(value));
        }

        public void Write(string value)
        {
            Write(Encoding.UTF8.GetBytes(value));
        }

        public void Dispose()
        {
            if (!m_LeaveOpen)
            {
                m_Channel.Dispose();
            }
        }
    }
}
