﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

using System.Net;
using System.Net.Sockets;

namespace Nintendo.HtcTools.HtclowEchoHost
{
    public class Program
    {
        private const int HtclowListenPort = 20180;
        private const byte ModuleId = 0;
        private const int ChannelIdStart = 1;
        private const int ChannelCount = 8;

        private static TimeSpan RetryInterval = TimeSpan.FromSeconds(1);

        internal static Task MakeEchoTask(HtclowClient htclowClient, ushort channelId)
        {
            return new Task(() =>
            {
                using (var channel = htclowClient.OpenChannel(ModuleId, channelId))
                using (var reader = new HtclowReader(channel))
                using (var writer = new HtclowWriter(channel))
                {
                    try
                    {
                        channel.Connect();
                        while (true)
                        {
                            // サイズを受信
                            var size = reader.ReadInt32();

                            if (size == 0)
                            {
                                // サイズ 0 が指定されたら通信終了
                                break;
                            }

                            // データを受信
                            Console.WriteLine($"read {size} byte channel {channelId}");
                            var data = reader.Read(size);

                            // データを送信
                            Console.WriteLine($"write {size} byte channel {channelId}");
                            writer.Write(data);
                        }
                    }
                    catch (Exception e)
                    {
                        Console.WriteLine(e.Message);
                    }
                    finally
                    {
                        channel.Shutdown();
                    }
                }

            });
        }

        public static void Main(string[] args)
        {
            if (args.Length != 1)
            {
                Console.WriteLine("Usage: HtclowEchoHost.exe <target IP address>");
                Environment.Exit(1);
            }
            string server = args[0];

            var task = Task.Run(() =>
            {
                while (true)
                {
                    try
                    {
                        Console.WriteLine($"Try to connect {server} ...");

                        var tcpClient = new TcpClient(server, HtclowListenPort);

                        Console.WriteLine("Established.");

                        var htclowClient = new HtclowClient(tcpClient.GetStream());

                        var tasks = new Task[ChannelCount];
                        for (var i = 0; i < ChannelCount; i++)
                        {
                            tasks[i] = MakeEchoTask(htclowClient, (ushort)(ChannelIdStart + i));
                            tasks[i].Start();
                        }
                        Task.WaitAll(tasks);

                        Console.WriteLine("Closed.");
                    }
                    catch (SocketException)
                    {
                        Task.Delay(RetryInterval.Milliseconds).Wait();
                    }
                }
            });
            task.Wait();
        }
    }
}
