﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Nintendo.HtcTools.HtcfsLibrary
{
    internal class SpanBuffer
    {
        private byte[] buffer;

        public SpanBuffer(int size)
        {
            buffer = new byte[size];
        }

        public SpanBuffer(byte[] buffer)
        {
            this.buffer = buffer;
        }

        public int Length
        {
            get
            {
                return buffer.Length;
            }
        }

        public byte[] GetBytes()
        {
            return buffer;
        }

        public short GetInt16(int byteOffset)
        {
            var span = new Span<byte>(buffer);
            return span.Slice(byteOffset).NonPortableCast<byte, short>()[0];
        }

        public void SetInt16(int byteOffset, short value)
        {
            var span = new Span<byte>(buffer);
            span.Slice(byteOffset).NonPortableCast<byte, short>()[0] = value;
        }

        public int GetInt32(int byteOffset)
        {
            var span = new Span<byte>(buffer);
            return span.Slice(byteOffset).NonPortableCast<byte, int>()[0];
        }

        public void SetInt32(int byteOffset, int value)
        {
            var span = new Span<byte>(buffer);
            span.Slice(byteOffset).NonPortableCast<byte, int>()[0] = value;
        }

        public long GetInt64(int byteOffset)
        {
            var span = new Span<byte>(buffer);
            return span.Slice(byteOffset).NonPortableCast<byte, long>()[0];
        }

        public void SetInt64(int byteOffset, long value)
        {
            var span = new Span<byte>(buffer);
            span.Slice(byteOffset).NonPortableCast<byte, long>()[0] = value;
        }
    }
}
