﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <cstdio>
#include <Windows.h>

void CONSOLE_TEXT_RED();
void CONSOLE_TEXT_GREEN();
void CONSOLE_TEXT_WHITE();
void CONSOLE_TEXT_GRAY();

#define PRINT_ERROR_MSG( _fmt_, ... )   \
{                                       \
    CONSOLE_TEXT_RED();                 \
    printf( "[ERROR] : " );             \
    printf( _fmt_, ##__VA_ARGS__ );     \
    fflush( stdout );                   \
    CONSOLE_TEXT_GRAY();                \
}

#define PRINT_OK_MSG( _fmt_, ... )      \
{                                       \
    CONSOLE_TEXT_GREEN();               \
    printf( "[OK] : " );                \
    printf( _fmt_, ##__VA_ARGS__ );     \
    fflush( stdout );                   \
    CONSOLE_TEXT_GRAY();                \
}

#define PRINT_INSTRUCTION_MSG( _fmt_, ... )      \
{                                       \
    CONSOLE_TEXT_WHITE();               \
    printf( _fmt_, ##__VA_ARGS__ );     \
    fflush( stdout );                   \
    CONSOLE_TEXT_GRAY();                \
}
