﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include "Portability.h"

class CrossBar;

class BridgeUtil
{
public:
    BridgeUtil(void);
    ~BridgeUtil(void);

    static bool Enumerate( int timeout );
    static bool Find( const tics::portability::stl::string& name, int timeout, tics::portability::stl::string* ip, int* port );

    bool Takeover( const tics::portability::stl::string& ipPort );
    bool Release();

    bool SetBridgeConfig( const tics::portability::stl::string& ipPort, const tics::portability::stl::string& attr, const tics::portability::stl::string& value );
    bool GetBridgeConfig( const tics::portability::stl::string& ipPort, tics::portability::stl::string* config );

    bool UpdateBridgeFirmware( const tics::portability::stl::string& ipPort, const tics::portability::stl::string& filePath );
    bool GetBridgeFirmwareVersion( const tics::portability::stl::string& ipPort, unsigned int* packageVersion);

    bool ControlTargetPower( const tics::portability::stl::string& ipPort, BridgeTargetPowerState powerState, bool force);

    bool SetTargetStatus( const tics::portability::stl::string& ipPort, ETargetStatusFlag flag, bool state );
    bool GetTargetStatus( const tics::portability::stl::string& ipPort);

    BridgeHandle GetHandle();

    static int OnGetBridgeFirmwareVersion( void* ctx, int operationResult, void* bridgeFirmwareVersion );

private:
    BridgeHandle m_BridgeHandle;
    bool m_bTakenOver;
    CrossBar * m_CrossBar;
};

