﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include "Portability.h"
#include "ResetEvent.h"

using namespace tics;
using namespace TicsTestCommon;

class BridgeEnumCallbackHandler : public portability::mem::Newable
{
public:
    BridgeEnumCallbackHandler();
    explicit BridgeEnumCallbackHandler( const char* name );

    ~BridgeEnumCallbackHandler();

    // Callbacks
    static int BridgeEnumCallback( void* ctx, int operationResult, BridgeHandle hOneBridge );

public:
    char* bridgeName;
    bool isBridgeFound;
    int totalBridgesFound;
    portability::stl::vector<portability::stl::string> discoveredBridgeNames;
    portability::stl::vector<portability::stl::string> discoveredBridgeIPs;
    portability::stl::vector<int> discoveredBridgePorts;
    portability::stl::vector<portability::stl::string> discoveredBridgeMacAddrs;
};

class BridgeCallbackHandlerBase : public portability::mem::Newable
{
public:
    BridgeCallbackHandlerBase();
    ~BridgeCallbackHandlerBase();

    void Reset();

    AutoResetEvent* GetAutoResetEvent() const;
    void* GetLastOperationResources() const;
    int GetLastOperationResult() const;

    static int OnOperationComplete( void* ctx, int operationResult, void* bridgeFirmwareVersion );

protected:
    AutoResetEvent* pAutoResetEvent;
    int lastOperationResult;
    void* lastOperationResources;
};

class GetConfigSectionCallbackHandler : public BridgeCallbackHandlerBase
{
    public:
    GetConfigSectionCallbackHandler(){};
    ~GetConfigSectionCallbackHandler(){};

    // Callbacks
    static int OnGetConfigSection( void* ctx, int operationResult, void* bridgeFirmwareVersion );
};

class GetBridgeFirmwareVersionCallbackHandler : public BridgeCallbackHandlerBase
{
public:
    GetBridgeFirmwareVersionCallbackHandler(){};
    ~GetBridgeFirmwareVersionCallbackHandler(){};

    // Callbacks
    static int OnGetBridgeFirmwareVersion( void* ctx, int operationResult, void* bridgeFirmwareVersion );
};

class BridgeTargetStateCallbackHandler : public BridgeCallbackHandlerBase
{
public:
    BridgeTargetStateCallbackHandler(){};
    ~BridgeTargetStateCallbackHandler(){};

    static int OnGetTargetStatus(void *ctx, int operationResult, TargetStatusFlags flags, TargetStatusFlags validityMask, BridgeCallbackInfo *resources);
};
