﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.IO;
using Nintendo.Foundation.IO;

namespace ConcatnateFiles
{
    public class ProgramArguments
    {
        [CommandLineOption('o', "output",
            Description = "Output file path",
            IsRequired = true)]
        public string OutputPath { get; set; }

        [CommandLineOption('i', "input",
            Description = "Input file path",
            IsRequired = true)]
        public string[] InputPathList { get; set; }
    }

    internal class Program
    {
        private static void Main(string[] args)
        {
            try
            {
                ProgramArguments arguments = new ProgramArguments();
                if (CommandLineParser.Default.ParseArgs<ProgramArguments>(args, out arguments))
                {
                    foreach (var inputPath in arguments.InputPathList)
                    {
                        if (!File.Exists(inputPath))
                        {
                            throw new Exception(string.Format("{0} is not found.", inputPath));
                        }
                    }

                    using (var outputFile = File.OpenWrite(arguments.OutputPath))
                    {
                        foreach (var inputPath in arguments.InputPathList)
                        {
                            using (var inputFile = File.OpenRead(inputPath))
                            {
                                inputFile.CopyTo(outputFile);
                            }
                        }
                    }
                }
                else
                {
                    return;
                }
            }
            catch (Exception exception)
            {
                Console.Error.WriteLine("エラー: {0}", exception.Message);
                Console.Error.WriteLine("{0}", exception.StackTrace);
                Environment.Exit(1);
            }
        }
    }
}
