﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include "detail/OpusCodecImpl.h"

namespace Nintendo {
namespace CodecTool {

/// <summary>
/// Opus ヘッダ内のマルチストリーム情報です。
/// </summary>

public ref class OpusMultiStreamInfo
{
private:
    property int type;                          // 情報タイプ
public:
    // 書き出すデータ
    property int size;                          // サイズ
    property unsigned char totalStreamCount;    // 合計ストリーム数
    property unsigned char stereoStreamCount;   // ステレオストリーム数
    property unsigned short padding;            // パディング (channelCount を書き出さないので、4 - sizeof(totalStreamCount) - sizeof(stereoStreamCount) バイト分確保)
    property array<uint8_t>^ channelMapping;    // チャンネルマッピング

    // 書き出さないデータ
    property unsigned char channelCount;        // チャンネル数
    OpusMultiStreamInfo();
    /// <summary>
    /// マルチストリーム情報を writer に書き込みます。
    /// </summary>
    void WriteHeader(System::IO::BinaryWriter^ writer);
};

}  // namespace CodecTool
}  // namespace Nintendo
