﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Linq;
using BezelEditor.Mvvm;
using Livet.Messaging.Windows;
using Nintendo.Authoring.AuthoringEditor.Core;
using Reactive.Bindings;
using Reactive.Bindings.Extensions;

namespace Nintendo.Authoring.AuthoringEditor.SettingWindow
{
    public class SettingWindowVm : ViewModelBase
    {
        public ReactiveCommand CloseCommand { get;  }
        public ReactiveProperty<CultureSummry> Culture { get; }

        public SettingWindowVm(Config config)
        {
            CloseCommand = new ReactiveCommand().AddTo(CompositeDisposable);
            CloseCommand
                .Subscribe(_ => Messenger.Raise(new WindowActionMessage(WindowAction.Close, "WindowAction")))
                .AddTo(CompositeDisposable);

            Culture = config.ToReactivePropertyAsSynchronized(
                x => x.Culture,
                convert: x => Constants.SupportedCultures.FirstOrDefault(y => y.CultureName == x),
                convertBack: x => x.CultureName
            ).AddTo(CompositeDisposable);
        }
    }
}
