﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Reactive.Linq;
using BezelEditor.Foundation.Extentions;
using BezelEditor.Mvvm;
using Reactive.Bindings;

namespace Nintendo.Authoring.AuthoringEditor
{
    // 注意：ARelativeSource の AncestorType で利用したいが、インターフェースだと受け付けないためクラスにしている
    public class SearchWordPanelVm : ViewModelBase
    {
        public ReactiveProperty<string> DelaySearchWord { get; }
        public ReactiveProperty<string> SearchWord { get; }

        public SearchWordPanelVm()
        {
            SearchWord = new ReactiveProperty<string>(string.Empty).AddTo(CompositeDisposable);

            DelaySearchWord = SearchWord
                .Throttle(TimeSpan.FromMilliseconds(250))
                .ToReactiveProperty()
                .AddTo(CompositeDisposable);
        }
    }
}
