﻿using System.Reactive.Linq;
using Nintendo.Authoring.AuthoringEditor.Core;
using Nintendo.Authoring.AuthoringEditor.Foundation;
using Reactive.Bindings;
using Reactive.Bindings.Extensions;

namespace Nintendo.Authoring.AuthoringEditor.MainWindow.ProjectEditPanel.Params
{
    public class SaveDataSummryParamVm : ParamVm
    {
        public ReadOnlyReactiveProperty<string> TotalSizeString { get; }

        public SaveDataSummryParamVm(string captionTag, string commentTag, ApplicationMeta appMeta)
            : base(captionTag, commentTag, null)
        {
            var app = appMeta.Application;

            TotalSizeString = Observable
                .Merge(app.ObserveProperty(x => x.IsUseSaveData).ToUnit())
                .Merge(app.ObserveProperty(x => x.SaveDataSize).ToUnit())
                .Merge(app.ObserveProperty(x => x.IsSpecifiedSaveDataJournal).ToUnit())
                .Merge(app.ObserveProperty(x => x.SaveDataJournalSize).ToUnit())
                .Select(x => app.TotalSaveDataSize.ToReadableSizeString())
                .ToReadOnlyReactiveProperty()
                .AddTo(CompositeDisposable);
        }
    }
}
