﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.ObjectModel;
using System.Diagnostics;
using System.Linq;
using System.Reactive.Linq;
using BezelEditor.Mvvm;
using Nintendo.Authoring.AuthoringEditor.Core;
using Nintendo.Authoring.AuthoringEditor.Foundation;
using Reactive.Bindings;
using Reactive.Bindings.Extensions;

namespace Nintendo.Authoring.AuthoringEditor.MainWindow.ProjectEditPanel.Params
{
    public class PatchHistoryParamVm : ParamVm
    {
        public ReadOnlyReactiveCollection<PatchHistoryVm> Histories { get; set; }

        public PatchHistoryParamVm(string captionTag, string commentTag, ObservableCollection<ContentMeta> model)
            : base(captionTag, commentTag, null)
        {
            Debug.Assert(model != null);

            Histories =
                model.ToReadOnlyReactiveCollection(x => new PatchHistoryVm(x, IsReadOnly))
                    .AddTo(CompositeDisposable);
        }

        protected override bool IsVisibled(string keyword)
        {
            if (base.IsVisibled(keyword))
                return true;

            if (Histories.Any() == false)
                return false;

            var texts = new[]
            {
                Properties.Resources.PatchHistory_Caption,
                Properties.Resources.PatchHistory_Comment
            };

            foreach (var text in texts)
                if (text.IndexOf(keyword, StringComparison.OrdinalIgnoreCase) != -1)
                    return true;

            return false;
        }
    }

    public class PatchHistoryVm : ViewModelBase
    {
        public ContentMeta Model { get; }

        public ReactiveProperty<ContentMetaType> Type { get; }
        public ReactiveProperty<ushort> ReleaseVersion { get; }
        public ReactiveProperty<string> RomDigest { get; }

        public ReactiveProperty<bool> IsReadOnly { get; }

        public PatchHistoryVm(ContentMeta model, ReactiveProperty<bool> isReadOnly)
        {
            Debug.Assert(model != null);

            Model = model;
            IsReadOnly = isReadOnly;

            Type = model.ToReactivePropertyAsSynchronized(x => x.Type).AddTo(CompositeDisposable);
            ReleaseVersion = model
                .ObserveProperty(x => x.Version)
                .Select(x => (ushort)(x >> 16))
                .ToReactiveProperty()
                .AddTo(CompositeDisposable);
            RomDigest = model.ToReactivePropertyAsSynchronized(x => x.Digest).AddTo(CompositeDisposable);
        }
    }

}
