﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.ObjectModel;
using System.Diagnostics;
using System.Linq;
using BezelEditor.Mvvm;
using Nintendo.Authoring.AuthoringEditor.Core;
using Reactive.Bindings;
using Reactive.Bindings.Extensions;

namespace Nintendo.Authoring.AuthoringEditor.MainWindow.ProjectEditPanel.Params
{
    public class MiddlewareParamVm : ParamVm
    {
        public ReadOnlyReactiveCollection<MiddlewareVm> Middlewares { get; set; }

        public MiddlewareParamVm(string captionTag, string commentTag, ObservableCollection<Middleware> model)
            : base(captionTag, commentTag, null)
        {
            Debug.Assert(model != null);

            Middlewares =
                model.ToReadOnlyReactiveCollection(middleware => new MiddlewareVm(middleware, IsReadOnly))
                    .AddTo(CompositeDisposable);
        }

        protected override bool IsVisibled(string keyword)
        {
            if (base.IsVisibled(keyword))
                return true;

            if (Middlewares.Any() == false)
                return false;

            var texts = new[]
            {
                Properties.Resources.Middleware_ModuleName_Caption,
                Properties.Resources.Middleware_VendorName_Caption
            };

            foreach (var text in texts)
                if (text.IndexOf(keyword, StringComparison.OrdinalIgnoreCase) != -1)
                    return true;

            return false;
        }
    }

    public class MiddlewareVm : ViewModelBase
    {
        public Middleware Model { get; }

        public ReactiveProperty<string> ModuleName { get; }
        public ReactiveProperty<string> VendorName { get; }

        public ReactiveProperty<bool> IsReadOnly { get; }

        public MiddlewareVm(Middleware model, ReactiveProperty<bool> isReadOnly)
        {
            Debug.Assert(model != null);

            Model = model;
            IsReadOnly = isReadOnly;

            ModuleName = model.ToReactivePropertyAsSynchronized(x => x.ModuleName).AddTo(CompositeDisposable);
            VendorName = model.ToReactivePropertyAsSynchronized(x => x.VendorName).AddTo(CompositeDisposable);
        }
    }
}
