﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System.IO;
using System.Reactive.Linq;
using System.Windows;
using BezelEditor.Foundation.Extentions;
using BezelEditor.Mvvm;
using Reactive.Bindings;
using Reactive.Bindings.Extensions;
using Nintendo.Authoring.AuthoringEditor.Properties;

namespace Nintendo.Authoring.AuthoringEditor.MainWindow.ProjectEditPanel.Params
{
    public class LegalInformationAddtionalVm : ViewModelBase
    {
        public ReactiveProperty<Visibility> Visibility { get; }

        public ReactiveProperty<string> LegalInformationPath { get; }

        public FileOpenerVm[] Items { get; }

        public LegalInformationAddtionalVm(ReactiveProperty<string> legalInformationPathRp)
        {
            Visibility = new ReactiveProperty<Visibility>(System.Windows.Visibility.Visible).AddTo(CompositeDisposable);

            LegalInformationPath = legalInformationPathRp.AddTo(CompositeDisposable);

            Items = new []
            {
                new FileOpenerVm(
                    nameof(Resources.OpenNspContainsLegalInfo_Support_Caption),
                    LegalInformationPath.Select(x => Path.Combine(x, "support.htdocs")).ToReactiveProperty()
                )
                {
                    OpenAsExplorer = true,
                }.AddTo(CompositeDisposable),

                new FileOpenerVm(
                    nameof(Resources.OpenNspContainsLegalInfo_IpNotices_Caption),
                    LegalInformationPath.Select(x => Path.Combine(x, "ipnotices.htdocs")).ToReactiveProperty()
                )
                {
                    OpenAsExplorer = true,
                }.AddTo(CompositeDisposable),
            };
        }
    }
}
