﻿using System;
using Reactive.Bindings;
using Reactive.Bindings.Extensions;

namespace Nintendo.Authoring.AuthoringEditor.MainWindow.ProjectEditPanel.Params
{
    public class CommandParamVm : ParamVm
    {
        public ReactiveCommand Command { get; }

        public CommandParamVm(string captionTag, string commentTag, Action action)
            : base(captionTag, commentTag, null)
        {
            Command = new ReactiveCommand()
                .AddTo(CompositeDisposable);

            Command
                .Subscribe(_ => action?.Invoke())
                .AddTo(CompositeDisposable);
        }
    }
}
