﻿using System;
using System.Linq;
using System.Windows;
using Nintendo.Authoring.AuthoringEditor.Controls;
using Nintendo.Authoring.AuthoringEditor.Foundation;
using Nintendo.Authoring.AuthoringEditor.Properties;
using Reactive.Bindings;
using Reactive.Bindings.Extensions;

namespace Nintendo.Authoring.AuthoringEditor.MainWindow.ProjectEditPanel.Params
{
    public class CapacityParamVm : HexParamVm
    {
        public bool IsVisibleStyleSelector { get; set; } = true;
        public CapacityEditBox.EditingStyles EditingStyle { get; set; } = CapacityEditBox.EditingStyles.KiroBytes;

        public CapacityEditBox.EditingStyles[] EditingStyleCandidates { get; set; }
        = Enum.GetValues(typeof(CapacityEditBox.EditingStyles)).Cast<CapacityEditBox.EditingStyles>().ToArray();

        public string UnitCaption
            => _UnitCaptionTag == null ? null : Resources.ResourceManager.GetString(_UnitCaptionTag, Resources.Culture);

        public ReactiveProperty<string> WarningMessage { get; }
        public ReactiveCommand CopyCommand { get; set; }

        private readonly string _UnitCaptionTag;

        public CapacityParamVm(string captionTag, string commentTag, IReactiveProperty property,
            int digitsOfChar,
            ulong minimum, ulong maximum,
            string unitCaptionTag)
            : base(captionTag, commentTag, property, digitsOfChar, minimum, maximum)
        {
            WarningMessage = new ReactiveProperty<string>().AddTo(CompositeDisposable);

            CopyCommand = new ReactiveCommand().AddTo(CompositeDisposable);
            CopyCommand.Subscribe(_ =>
            {
                var text = NumberHelper.ToReadableSizeString(property.Value);
                try
                {
                    Clipboard.SetText(text);
                }
                catch
                {
                    // クリップボード関連の例外はすべて無視する
                }
            });

            _UnitCaptionTag = unitCaptionTag;

            CultureService.Instance.ObserveProperty(x => x.Resources)
                .Subscribe(_ =>
                {
                    // ReSharper disable ExplicitCallerInfoArgument
                    RaisePropertyChanged(nameof(UnitCaption));
                    // ReSharper restore ExplicitCallerInfoArgument
                })
                .AddTo(CompositeDisposable);
        }
    }

}
