﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System.Linq;
using Nintendo.Authoring.AuthoringEditor.Core;
using Nintendo.Authoring.AuthoringEditor.MainWindow.ProjectEditPanel.Params;
using Reactive.Bindings.Extensions;
using static Nintendo.Authoring.AuthoringEditor.Properties.Resources;

namespace Nintendo.Authoring.AuthoringEditor.MainWindow.ProjectEditPanel.Pages
{
    public class PlayLogsPageVm : PageVmBase
    {
        public EnumParamVm PlayLogQueryCapability { get; }
        public ApplicationIdParamVm PlayLogQueryableApplicationId { get; }

        public PlayLogsPageVm(Project project, ApplicationMeta appMeta)
            : base(nameof(PlayLogs))
        {
            var isReadOnlyRp = appMeta.ToReactivePropertyAsSynchronized(x => x.IsReadOnly).AddTo(CompositeDisposable);

            /////////////////////////////////////////////////////////
            if (project.AppCapability.IsSupportPlayLogs)
            {
                PlayLogQueryCapability = EnumParamVm.Factory(
                    nameof(PlayLogQueryCapability_Caption),
                    nameof(PlayLogQueryCapability_Comment),
                    appMeta.Application.ToReactivePropertyAsSynchronized(x => x.PlayLogQueryCapability),
                    new object[]
                    {
                        PlayLogQueryCapabilityType.WhiteList,
                        PlayLogQueryCapabilityType.All
                    }
                ).AddTo(CompositeDisposable);
                PlayLogQueryCapability.IsReadOnly = isReadOnlyRp;

                PlayLogQueryableApplicationId = new ApplicationIdParamVm(
                    nameof(PlayLogQueryableApplicationId_Caption),
                    nameof(PlayLogQueryableApplicationId_Comment),
                    nameof(AddPlayLogQueryableApplicationId),
                    appMeta.Application.PlayLogQueryableApplicationIds,
                    Core.Application.MaxPlayLogQueryableApplicationIdCount,
                    isReadOnlyRp
                ).AddTo(CompositeDisposable);
            }

            /////////////////////////////////////////////////////////
            var allSelected = appMeta.Application.PlayLogQueryCapability == PlayLogQueryCapabilityType.All;
            Params = new ParamVm[]
            {
                allSelected ? PlayLogQueryCapability : null,
                PlayLogQueryableApplicationId
            }.Where(x => x != null).ToArray();
        }
    }
}
