﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System.Linq;
using Nintendo.Authoring.AuthoringEditor.Controls;
using Nintendo.Authoring.AuthoringEditor.Core;
using Nintendo.Authoring.AuthoringEditor.Foundation;
using Nintendo.Authoring.AuthoringEditor.MainWindow.ProjectEditPanel.Params;
using Nintendo.Authoring.AuthoringEditor.Properties;
using Reactive.Bindings.Extensions;

namespace Nintendo.Authoring.AuthoringEditor.MainWindow.ProjectEditPanel.Pages
{
    public class NspSizePageVm : PageVmBase
    {
        public CapacityParamVm DownloadSize { get; }
        public CapacityParamVm ApplicationUsedAreaOnCard { get; }
        public CapacityParamVm ApplicationAvailableAreaOnCard { get; }
        public CapacityParamVm MinimumSaveDataSize { get; }
        public CapacityParamVm EachUserAccountSaveDataSize { get; }

        public NspSizePageVm(Project project)
            : base(nameof(Resources.SizeInformation))
        {
            var props =
                project.ContentMetaProperties.Properties.FirstOrDefault(
                    x => x.Type == ContentMetaType.Application || x.Type == ContentMetaType.Patch);
            if (props == null)
            {
                Params = new ParamVm[] {};
                return;
            }

            var isPatch = props.Type == ContentMetaType.Patch;

            /////////////////////////////////////////////////////////
            var downloadSizeRp = props.Size.ToReactivePropertyAsSynchronized(x => x.DownLoad);
            DownloadSize = new CapacityParamVm(
                isPatch ? nameof(Resources.PatchDownloadSize_Caption) : nameof(Resources.DownloadSize_Caption),
                isPatch ? nameof(Resources.PatchDownloadSize_Comment) : nameof(Resources.DownloadSize_Comment),
                downloadSizeRp,
                16,
                0x0000000000000000,
                0x7FFFFFFFFFFFFFFF,
                null
            ).AddTo(CompositeDisposable);
            DownloadSize.IsReadOnly.Value = true;
            DownloadSize.EditingStyle = CapacityEditBox.EditingStyles.MegaBytes;
            DownloadSize.EditingStyleCandidates = new[]
                {CapacityEditBox.EditingStyles.Bytes, CapacityEditBox.EditingStyles.MegaBytes, CapacityEditBox.EditingStyles.GigaBytes};

            /////////////////////////////////////////////////////////
            var usedAreaOnCardRp = props.Size.ToReactivePropertyAsSynchronized(x => x.ApplicationAreaUsedOnCard);
            ApplicationUsedAreaOnCard = new CapacityParamVm(
                isPatch ? nameof(Resources.PatchAreaUsedOnCard_Caption) : nameof(Resources.ApplicationAreaUsedOnCard_Caption),
                isPatch ? nameof(Resources.PatchAreaUsedOnCard_Comment) : nameof(Resources.ApplicationAreaUsedOnCard_Comment),
                usedAreaOnCardRp,
                16,
                0x0000000000000000,
                0x7FFFFFFFFFFFFFFF,
                null
            ).AddTo(CompositeDisposable);
            ApplicationUsedAreaOnCard.IsReadOnly.Value = true;
            ApplicationUsedAreaOnCard.EditingStyle = CapacityEditBox.EditingStyles.MegaBytes;
            ApplicationUsedAreaOnCard.EditingStyleCandidates = new[]
                {CapacityEditBox.EditingStyles.Bytes, CapacityEditBox.EditingStyles.MegaBytes, CapacityEditBox.EditingStyles.GigaBytes};

            /////////////////////////////////////////////////////////
            var availableAreaOnCardRp = props.Size.ToReactivePropertyAsSynchronized(x => x.ApplicationAreaAvailableOnCard);
            ApplicationAvailableAreaOnCard = new CapacityParamVm(
                nameof(Resources.ApplicationAreaAvailableOnCard_Caption),
                nameof(Resources.ApplicationAreaAvailableOnCard_Comment),
                availableAreaOnCardRp,
                16,
                0x0000000000000000,
                0x7FFFFFFFFFFFFFFF,
                null
            ).AddTo(CompositeDisposable);
            ApplicationAvailableAreaOnCard.IsReadOnly.Value = true;
            ApplicationAvailableAreaOnCard.EditingStyle = CapacityEditBox.EditingStyles.MegaBytes;
            ApplicationAvailableAreaOnCard.EditingStyleCandidates = new[]
                {CapacityEditBox.EditingStyles.Bytes, CapacityEditBox.EditingStyles.MegaBytes, CapacityEditBox.EditingStyles.GigaBytes};

            /////////////////////////////////////////////////////////
            var minimumSaveDataRp = props.Size.ToReactivePropertyAsSynchronized(x => x.MinimumSaveData);
            MinimumSaveDataSize = new CapacityParamVm(
                nameof(Resources.MinimumSaveDataSize_Caption),
                nameof(Resources.MinimumSaveDataSize_Comment),
                minimumSaveDataRp,
                16,
                0x0000000000000000,
                0x7FFFFFFFFFFFFFFF,
                null
            ).AddTo(CompositeDisposable);
            MinimumSaveDataSize.IsReadOnly.Value = true;
            MinimumSaveDataSize.EditingStyle = CapacityEditBox.EditingStyles.MegaBytes;
            MinimumSaveDataSize.EditingStyleCandidates = new[]
                {CapacityEditBox.EditingStyles.Bytes, CapacityEditBox.EditingStyles.KiroBytes, CapacityEditBox.EditingStyles.MegaBytes};

            /////////////////////////////////////////////////////////
            var eachUserAccountSaveDataRp = props.Size.ToReactivePropertyAsSynchronized(x => x.EachUserAccountSaveData);
            EachUserAccountSaveDataSize = new CapacityParamVm(
                nameof(Resources.EachUserAccountSaveDataSize_Caption),
                nameof(Resources.EachUserAccountSaveDataSize_Comment),
                eachUserAccountSaveDataRp,
                16,
                0x0000000000000000,
                0x7FFFFFFFFFFFFFFF,
                null
            ).AddTo(CompositeDisposable);
            EachUserAccountSaveDataSize.IsReadOnly.Value = true;
            EachUserAccountSaveDataSize.EditingStyle = CapacityEditBox.EditingStyles.MegaBytes;
            EachUserAccountSaveDataSize.EditingStyleCandidates = new[]
                {CapacityEditBox.EditingStyles.Bytes, CapacityEditBox.EditingStyles.KiroBytes, CapacityEditBox.EditingStyles.MegaBytes};

            Params = new ParamVm[]
            {
                DownloadSize,
                ApplicationUsedAreaOnCard,
                ApplicationAvailableAreaOnCard,
                MinimumSaveDataSize,
                EachUserAccountSaveDataSize
            }.Where(x => x != null).ToArray();
        }
    }
}
