﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Reactive.Linq;
using Nintendo.Authoring.AuthoringEditor.Core;
using Nintendo.Authoring.AuthoringEditor.MainWindow.ProjectEditPanel.Params;
using Reactive.Bindings.Extensions;
using SimpleInjector;
using static Nintendo.Authoring.AuthoringEditor.Properties.Resources;

namespace Nintendo.Authoring.AuthoringEditor.MainWindow.ProjectEditPanel.Pages
{
    public class LanguagePageVm : PageVmBase
    {
        public SupportedLanguageParamVm SupportedLanguages { get; }

        public LanguagePageVm(Container diContainer, ApplicationMeta appMeta)
            : base(nameof(Language))
        {
            var isReadOnlyRp = appMeta.ToReactivePropertyAsSynchronized(x => x.IsReadOnly).AddTo(CompositeDisposable);

            /////////////////////////////////////////////////////////
            SupportedLanguages = new SupportedLanguageParamVm(
                diContainer,
                nameof(SupportedLanguage_Caption),
                nameof(SupportedLanguage_Comment),
                appMeta,
                appMeta.Application.SupportedLanguages,
                isReadOnlyRp
            ).AddTo(CompositeDisposable);

            /////////////////////////////////////////////////////////
            Params = new ParamVm[]
            {
                SupportedLanguages
            };

            /////////////////////////////////////////////////////////
            appMeta.Application.ObserveProperty(x => x.IsErrorSupportedLanguages)
                .Where(_ => isReadOnlyRp.Value == false)
                .Subscribe(i => HasErrors.Value = i)
                .AddTo(CompositeDisposable);
        }
    }
}
