﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System.Linq;
using Nintendo.Authoring.AuthoringEditor.Core;
using Nintendo.Authoring.AuthoringEditor.MainWindow.ProjectEditPanel.Params;
using Nintendo.Authoring.AuthoringEditor.Properties;
using Reactive.Bindings;
using Reactive.Bindings.Extensions;

namespace Nintendo.Authoring.AuthoringEditor.MainWindow.ProjectEditPanel.Pages
{
    public class FsAccessControlPageVm : PageVmBase
    {
        public StringParamVm FlagPresets { get; }
        public SaveDataOwnerIdParamVm SaveDataOwnerIds { get; }

        public FsAccessControlPageVm(AppProfile profile, Project project, ApplicationMeta meta)
            : base(nameof(Resources.FsAccessControl))
        {
            var isNspMode = profile.AppMode == AppModeType.ApplicationNsp ||
                            profile.AppMode == AppModeType.PatchNsp;
            var isReadOnly = meta.ToReactivePropertyAsSynchronized(x => x.IsReadOnly).AddTo(CompositeDisposable);

            /////////////////////////////////////////////////////////
            if (isNspMode == false)
            {
                FlagPresets = new StringParamVm(
                    nameof(Resources.FlagPresets_Caption),
                    nameof(Resources.FlagPresets_Comment),
                    meta.Core.FsAccessControlData.ToReactivePropertyAsSynchronized(x => x.FlagPresets)
                ).AddTo(CompositeDisposable);
                FlagPresets.Width = GuiConstants.ExtraSmallWidth;
                FlagPresets.IsUse = meta.Core.FsAccessControlData.ToReactivePropertyAsSynchronized(x => x.IsUseFlagPresets)
                    .AddTo(CompositeDisposable);
                FlagPresets.CaptionIsUseTag = nameof(Resources.IsUse);
                FlagPresets.IsReadOnly = isReadOnly;
            }

            /////////////////////////////////////////////////////////
            if (project.AppCapability.IsSupportSaveDataOwnerIds)
            {
                var ownerIds = isNspMode
                    ? project.ProgramInfo.FsAccessControlData.SaveDataOwnerIds
                    : meta.Core.FsAccessControlData.SaveDataOwnerIds;
                SaveDataOwnerIds = new SaveDataOwnerIdParamVm(
                    nameof(Resources.SaveDataOwnerId_Caption),
                    nameof(Resources.SaveDataOwnerId_Comment),
                    ownerIds,
                    new ReactiveProperty<bool>(isNspMode).AddTo(CompositeDisposable)
                ).AddTo(CompositeDisposable);
            }

            /////////////////////////////////////////////////////////
            Params = new ParamVm[]
            {
                FlagPresets,
                SaveDataOwnerIds
            }.Where(x => x != null).ToArray();
        }
    }
}
