﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using BezelEditor.Foundation.Extentions;
using Nintendo.Authoring.AuthoringEditor.Core;
using Nintendo.Authoring.AuthoringEditor.MainWindow.ProjectEditPanel.Params;
using Nintendo.Authoring.AuthoringEditor.Properties;

namespace Nintendo.Authoring.AuthoringEditor.MainWindow.ProjectEditPanel.Pages
{
    public class ApplicationMetaErrorPageVm : PageVmBase
    {
        public ApplicationMetaErrorPageVm(ApplicationMeta appMeta) : base(nameof(Resources.Error_Application))
        {
            var fileFormatErrors = new ErrorListParamVm(
                    nameof(Resources.Error_Application_Caption),
                    nameof(Resources.Error_Application_Comment),
                    appMeta.FileFormatErrors
                ).AddTo(CompositeDisposable);

            Params = new ParamVm[]
            {
                fileFormatErrors
            };
        }
    }
}
