﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Reactive.Linq;
using System.Windows;
using System.Windows.Controls;
using BezelEditor.Control;
using BezelEditor.Foundation.Extentions;
using BezelEditor.Foundation.Utilities;
using Fluent;
using Nintendo.Authoring.AuthoringEditor.MainWindow.AppMenu;

namespace Nintendo.Authoring.AuthoringEditor.MainWindow
{
    /// <summary>
    /// MainWindow.xaml の相互作用ロジック
    /// </summary>
    public partial class MainWindow
    {
        public MainWindow()
        {
            InitializeComponent();
        }

        private void RibbonWindow_MouseLeftButtonDown(object sender, System.Windows.Input.MouseButtonEventArgs e)
        {
            DragMove();
        }

        private void ApplicationMenu_DataContextChanged(object sender, DependencyPropertyChangedEventArgs e)
        {
            var appMenu = sender as ApplicationMenu;
            var appMenuDataContext = appMenu?.DataContext as AppMenuVm;

            if (appMenuDataContext == null)
                return;

            Observable.FromEventPattern(
                    h => appMenuDataContext.ProjectOpening += h,
                    h => appMenuDataContext.ProjectOpening -= h)
                .Subscribe(_ =>
                {
                    appMenu.IsDropDownOpen = false;
                    WpfUtility.DoEvents();
                })
                .AddTo(appMenuDataContext.CompositeDisposable);

            appMenu.DropDownOpened += (_, __) =>
            {
                var sv = appMenu.FindVisualChild(typeof(ScrollViewer)) as ScrollViewer;
                if (sv != null)
                    sv.VerticalAlignment = VerticalAlignment.Top;
            };
        }

        private void MainWindow_OnDragEnter(object sender, DragEventArgs e)
        {
            var dataContext = (MainWindowVm) DataContext;

            dataContext.IsInDragging.Value = true;
        }

        private void MainWindow_OnDragLeave(object sender, DragEventArgs e)
        {
            var dataContext = (MainWindowVm) DataContext;

            dataContext.IsInDragging.Value = false;
        }
    }
}
