﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.ObjectModel;
using System.Linq;
using Nintendo.Authoring.AuthoringEditor.Core;
using Nintendo.Authoring.AuthoringEditor.Foundation;
using SimpleInjector;

namespace Nintendo.Authoring.AuthoringEditor.MainWindow.ComparisonPanel.ParamTreeBuilder
{
    public class AppMetaParamTreeBuilder :  AppNspParamTreeBuilder
    {
        protected override Param.ResultValue GetLegalInformationParamValue(Action<float> onProgress = null)
            => new Param.ResultValue
            {
                IsIdentical =
                    BinaryFile(Project0.ToAbsolutePath(App0.LegalInformationFilePath), new byte[0]).SequenceEqual(
                        BinaryFile(Project1.ToAbsolutePath(App1.LegalInformationFilePath), new byte[0])
                    ),
                HasValue0 = string.IsNullOrEmpty(App0.LegalInformationFilePath) == false,
                HasValue1 = string.IsNullOrEmpty(App1.LegalInformationFilePath) == false
            };

        protected override Param.ResultValue GetAccessibleUrlsParamValue(Action<float> onProgress = null)
            => new Param.ResultValue
            {
                IsIdentical = FileSystemHelper.IsEqualDirectory(
                    Project0.ToAbsolutePath(App0.HtmlDocumentPath),
                    Project1.ToAbsolutePath(App1.HtmlDocumentPath)),
                HasValue0 = string.IsNullOrEmpty(App0.HtmlDocumentPath) == false,
                HasValue1 = string.IsNullOrEmpty(App1.HtmlDocumentPath) == false
            };

        protected override Param.ResultValue GetHtmlDocumentParamValue(Action<float> onProgress = null)
            => new Param.ResultValue
            {
                IsIdentical = TextFile(Project0.ToAbsolutePath(App0.AccessibleUrlsFilePath)) ==
                              TextFile(Project1.ToAbsolutePath(App1.AccessibleUrlsFilePath)),
                HasValue0 = string.IsNullOrEmpty(App0.AccessibleUrlsFilePath) == false,
                HasValue1 = string.IsNullOrEmpty(App1.AccessibleUrlsFilePath) == false
            };

        protected override string GetNxIconFilePath(Project p, Title t) => p.ToAbsolutePath(t?.NxIconFilePath);
        protected override string GetIconFilePath(Project p, Title t) => p.ToAbsolutePath(t?.IconFilePath);

        public AppMetaParamTreeBuilder(Container diContainer, ObservableCollection<ComparisonPanelVm.Target> targets)
            : base(diContainer, targets)
        {

        }
    }
}
