﻿﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System.Collections.Generic;
using Nintendo.Authoring.AuthoringEditor.Core;
using Nintendo.Authoring.AuthoringEditor.Properties;

namespace Nintendo.Authoring.AuthoringEditor
{
    public static class GuiConstants
    {
        public const double ExtraSmallWidth = 100;
        public const double SemiSmallWidth = 150;
        public const double SmallWidth = 200;
        public const double MiddleWidth = 300;
        public const double LargeWidth = 400;
        public const double ExtraLargeWidth = 700;

        // ReSharper disable InconsistentNaming
        public static readonly string MessageKey_Dialog = "Dialog";
        public static readonly string MessageKey_FileOpen = "FileOpen";
        public static readonly string MessageKey_FileSave = "FileSave";
        public static readonly string MessageKey_DirectoryOpen = "DirectoryOpen";
        // ReSharper restore InconsistentNaming

        public class ImportableFile
        {
            public ImportableFile(string dialogFilter, string noName)
            {
                DialogFilter = dialogFilter;
                NoName = noName;
            }

            public string DialogFilter { get; }
            public string NoName { get; }
        }

        public static readonly IReadOnlyDictionary<ImportableFileType, ImportableFile> ImportableFileDict =
            new Dictionary<ImportableFileType, ImportableFile>
            {
                {ImportableFileType.Project, new ImportableFile(Resources.DialogFilter_Project, Resources.NoName_Project)},
                {ImportableFileType.Meta, new ImportableFile(Resources.DialogFilter_Meta, Resources.NoName_Meta)},
                {ImportableFileType.Nsp, new ImportableFile(Resources.DialogFilter_Nsp, Resources.NoName_Nsp)}
            };
    }
}
