﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Windows.Media.Animation;

namespace Nintendo.Authoring.AuthoringEditor.Controls
{
    /// <summary>
    /// InPreparationWindow.xaml の相互作用ロジック
    /// </summary>
    public partial class InPreparationWindow
    {
        public string Message
        {
            get { return MessageText.Text; }
            set { Dispatcher.Invoke(() => MessageText.Text = value); }
        }

        public InPreparationWindow(string message)
        {
            InitializeComponent();

            Message = message;
        }

        public event EventHandler HideComplited;

        public new void Hide()
        {
            IsHitTestVisible = false;
            var anim = TryFindResource("HideAnim") as Storyboard;

            if (anim != null)
                anim.Completed += (_, __) => HideComplited?.Invoke(this, null);

            anim?.Begin(this, true);
        }
    }
}
