﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Interactivity;
using Reactive.Bindings.Extensions;

namespace Nintendo.Authoring.AuthoringEditor.Behaviors
{
    public sealed class ComboBoxForeceUpdateTextOnCultureChangingBehavior : Behavior<ComboBox>
    {
        protected override void OnAttached()
        {
            AssociatedObject.Unloaded += AssociatedObjectOnUnloaded;
            base.OnAttached();

            _disposable = CultureService.Instance.ObserveProperty(x => x.Resources, false)
                .Subscribe(_ =>
                {
                    var t = AssociatedObject.Text;
                    AssociatedObject.Text = string.Empty;
                    AssociatedObject.Text = t;
                });
        }
        protected override void OnDetaching()
        {
            base.OnDetaching();

            AssociatedObject.Unloaded -= AssociatedObjectOnUnloaded;
        }

        private IDisposable _disposable;

        private void AssociatedObjectOnUnloaded(object sender, RoutedEventArgs routedEventArgs)
        {
            _disposable?.Dispose();
        }
    }
}
