﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Globalization;
using System.Windows;
using System.Windows.Interactivity;
using System.Windows.Media;
using BezelEditor.Control;
using Fluent;
using Reactive.Bindings.Extensions;

namespace Nintendo.Authoring.AuthoringEditor.Behaviors
{
    public sealed class ApplicationMenuForeceUpdateWidthOnCultureChangingBehavior : Behavior<ApplicationMenu>
    {
        protected override void OnAttached()
        {
            AssociatedObject.Unloaded += AssociatedObjectOnUnloaded;
            base.OnAttached();

            _disposable = CultureService.Instance.ObserveProperty(x => x.Resources, false)
                .Subscribe(_ =>
                {
                    var text = AssociatedObject.Header as string;

                    var a = AssociatedObject.FindVisualChild("PART_ButtonBorder") as FrameworkElement;
                    if (a == null)
                        return;

                    if (string.IsNullOrEmpty(text))
                        a.Width = AssociatedObject.MinWidth;

                    else
                    {
                        var ft = new FormattedText(
                            text,
                            CultureInfo.CurrentCulture,
                            FlowDirection.LeftToRight,
                            new Typeface(AssociatedObject.FontFamily.Source),
                            AssociatedObject.FontSize,
                            AssociatedObject.Foreground);

                        const double marginLeft = 10;
                        const double marginRight = 10;

                        a.Width = marginLeft + ft.Width + marginRight;
                    }
                });
        }

        protected override void OnDetaching()
        {
            base.OnDetaching();

            AssociatedObject.Unloaded -= AssociatedObjectOnUnloaded;
        }

        private IDisposable _disposable;

        private void AssociatedObjectOnUnloaded(object sender, RoutedEventArgs routedEventArgs)
        {
            _disposable?.Dispose();
        }
    }
}
