﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System.IO;

namespace Nintendo.Authoring.AuthoringEditor.Foundation
{
    public static class StreamHelper
    {
        public static bool IsEqual(Stream stream1, Stream stream2)
        {
            if (stream1 == null && stream2 == null)
                return true;

            if ((stream1 != null && stream2 != null) == false)
                return false;

            const int bufferSize = 16 * 1024;

            var buffer1 = new byte[bufferSize];
            var buffer2 = new byte[bufferSize];

            while (true)
            {
                var count1 = stream1.Read(buffer1, 0, bufferSize);
                var count2 = stream2.Read(buffer2, 0, bufferSize);

                if (count1 != count2)
                    return false;

                if (count1 == 0)
                    return true;

                if (ArrayHelper.IsEqual(buffer1, buffer2) == false)
                    return false;
            }
        }
    }
}
