﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;

namespace Nintendo.Authoring.AuthoringEditor.Foundation
{
    public static class NumberHelper
    {
        public static string ToReadableSizeString(this ulong size)
        {
            if (size <= 1)
                return $"{size}Byte";

            if (size < 1000)
                return $"{size}Bytes";

            if (size < 1000 * 1000)
                return $"{(decimal)size / 1000:0.###}KBytes {(decimal)size / 1024:0.###}KiB ({size}Bytes)";

            if (size < 1000 * 1000 * 1000)
                return $"{(decimal)size / 1000 / 1000:0.###}MBytes {(decimal)size / 1024 / 1024:0.###}MiB ({size}Bytes)";

            return $"{(decimal)size / 1000 / 1000 / 1000:0.###}GBytes {(decimal)size / 1024 / 1024 / 1024:0.###}GiB ({size}Bytes)";
        }

        public static string ToReadableSizeString(this long size)
        {
            if (size < 0)
                return "0Byte";
            return ToReadableSizeString((ulong) size);
        }

        public static string ToReadableSizeString(object size)
        {
            switch (size)
            {
                case long longSize:
                    return ToReadableSizeString(longSize);
                case ulong ulongSize:
                    return ToReadableSizeString(ulongSize);
                case uint uintSize:
                    return ToReadableSizeString(uintSize);
                default:
                    throw new ArgumentOutOfRangeException(nameof(size));
            }
        }

        public static string ToReadableSizeString(this uint size) => ToReadableSizeString((ulong)size);
    }
}
