﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Xml.Serialization;
using BezelEditor.Mvvm;
using YamlDotNet.Serialization;

namespace Nintendo.Authoring.AuthoringEditor.Core
{
    public class ExpandablePath : DisposableModelBase
    {
        public ExpandablePath()
        {

        }

        public ExpandablePath(string path)
        {
            _Path = path;
        }

        public ExpandablePath(ExpandablePath other)
        {
            if (other == null)
                return;
            _IsExpandEnvironmentVariable = other._IsExpandEnvironmentVariable;
            _Path = other._Path;
        }

        public bool SetExpandablePath(ExpandablePath other)
        {
            if (other == null)
            {
                other = new ExpandablePath();
            }
            var changed = false;
            if (IsExpandEnvironmentVariable != other.IsExpandEnvironmentVariable)
            {
                IsExpandEnvironmentVariable = other.IsExpandEnvironmentVariable;
                changed = true;
            }
            if (Path != other.Path)
            {
                Path = other.Path;
                changed = true;
            }
            return changed;
        }

        #region IsExpandEnvironmentVariable

        private bool _IsExpandEnvironmentVariable;

        [YamlIgnore]
        [XmlIgnore]
        public bool IsExpandEnvironmentVariable
        {
            get { return _IsExpandEnvironmentVariable; }
            set { SetProperty(ref _IsExpandEnvironmentVariable, value); }
        }

        [YamlIgnore]
        [XmlAttribute("UseEnvironmentVariable")]
        public string IsExpandEnvironmentVariableForXml
        {
            get { return IsExpandEnvironmentVariable ? "true" : null; }
            set
            {
                bool e;
                if (bool.TryParse(value, out e))
                    IsExpandEnvironmentVariable = e;
            }
        }

        #endregion

        #region Path

        private string _Path;

        [YamlIgnore]
        [XmlText]
        public string Path
        {
            get { return _Path; }
            set { SetProperty(ref _Path, value); }
        }

        #endregion

        #region ExpandPath

        [YamlIgnore]
        [XmlIgnore]
        public string ExpandPath => IsExpandEnvironmentVariable
            ? Environment.ExpandEnvironmentVariables(Path)
            : Path;

        #endregion

        [YamlIgnore]
        [XmlIgnore]
        public bool IsEmpty => string.IsNullOrEmpty(Path);

        public static implicit operator string(ExpandablePath value)
        {
            return value?.Path;
        }

        public static implicit operator ExpandablePath(string value)
        {
            return new ExpandablePath(value);
        }
    }
}
